/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.fungi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.blocks.fungi.FloorAndSidesMushroomBlock;
import com.ordana.spelunkery.reg.ModBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ConkFungusBlock
extends FloorAndSidesMushroomBlock
implements BonemealableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)11.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)5.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0)));

    public ConkFungusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FLOOR});
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)level, blockPos, direction);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        BlockState blockState = super.m_5573_(context);
        Level levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Direction[] var6 = directions = context.m_6232_();
        int var7 = directions.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction direction = var6[var8];
            if (blockState == null || !direction.m_122434_().m_122479_() || (blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction.m_122424_())) == null || !blockState.m_60710_((LevelReader)levelReader, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if (((ConfiguredFeature)((Holder)((Registry)level.m_5962_().m_6632_(Registry.f_122881_).get()).m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)Spelunkery.res("huge_conk_fungus_bonemeal"))).get()).m_203334_()).m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos)) {
            return true;
        }
        level.m_7731_(pos, state, 3);
        return false;
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.m_188501_() < 0.4;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growMushroom(level, pos, state, random);
        level.m_7731_(pos, ModBlocks.CONK_FUNGUS_BLOCK.get().m_49966_(), 3);
    }
}

